<style type="text/css">
    @media print {
  body {
    zoom: 80%; /* Shrinks everything a little to fit */
  }

  table {
    width: 100% !important;
    border-collapse: collapse;
    table-layout: fixed; /* force equal column widths */
  }

  th, td {
    font-size: 11px;  /* smaller text for fitting */
    padding: 4px;
    word-wrap: break-word; /* wrap long text */
    white-space: normal !important; /* allow wrapping */
  }

  /* Ensure header/footer buttons do not print */
  .no-print, button, .print-button {
    display: none !important;
  }

  /* Optional: always print in landscape */
  /*@page {
    size: A4 landscape;
    margin: 10mm;
  }*/
}

</style>

<div id="printable-container">
    <div class="app-page-title">
        <div class="page-title-wrapper">
        <div class="page-title-heading">
            <div class="page-title-icon">
                <i class="pe-7s-notebook text-success"></i>
            </div>
                <?php echo l('Check-in/out Report', true); ?>
        </div>
    </div>
</div>
     
<div class="main-card card">
    <div class="card-body">
    <div class="col-md-12">
        <div class="panel panel-default hidden-print">
            <div class="panel-body h4">
                <div class="form-inline">
                    <div class="form-group">
                        <?php echo l('Show bookings that are', true); ?>
                        <?php
                        $this->load->helper('customer_name');
                        $states = Array(
                            // "-1" => "All",
                            // RESERVATION => "Reservation",
                            'checking_in' => l("Checking-in"),
                            'checking_out' => l("Checking-out"),
                            // OUT_OF_ORDER => "Out of Order"
                        );
                        ?>
                        <select name="state" class="form-control">
                            <?php foreach ($states as $index => $state): ?>
                                <option
                                    value="<?php echo $index; ?>"
                                    <?php if ($selected_state == $index) { echo ' selected="selected"'; }?>
                                >
                                    <?php echo $state; ?>
                                </option>

                            <?php endforeach; ?>
                        </select>
                        <?php echo l('on date between', true); ?>
                        <input type="text" name="from_date" value="<?php echo $from_date; ?>" class="form-control" style="width: 100px;">
                        <?php echo l('and', true); ?>
                        <input type="text" name="to_date" value="<?php echo $to_date; ?>" class="form-control input-margin-fix" style="width: 100px;">

                        <?php
                        $inhouse_settings = $company_details['inhouse_settings'];
                        if($inhouse_settings == "") {
                            $inhouse_settings = "booking_id,status,room,check_in_date,check_out_date,customer_names,customer_email,customer_notes";
                        }
                        $settings = explode(',', $inhouse_settings);
                        ?>

                        <button id="generate_reserv_report" class="btn btn-success hidden-print"><?php echo l('Generate', true); ?></button>

                    </div>


                    <div class="button-group pull-right" style="margin: 2px;">
                        <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown"><span class="glyphicon glyphicon-cog"></span> 
                            <!-- <span class="caret"></span> -->
                            </button>
                        <ul class="dropdown-menu column_filter" style="top: 70px;">
                            <li name="booking_id"><a href="#" class="small" data-value="option1" value="booking_id"  tabIndex="-1"><input type="checkbox" class="columns_checkbox<?php if(in_array('booking_id', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('booking_id', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Booking', true).' '.l('Id', true); ?></a></li>
                            <li name="adult_count"><a href="#" class="small" data-value="option1" value="adult_count"  tabIndex="-1"><input type="checkbox" class="columns_checkbox<?php if(in_array('booking_id', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('adult_count', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Number of Adults', true); ?></a></li>
                            <li name="children_count"><a href="#" class="small" data-value="option1" value="children_count"  tabIndex="-1"><input type="checkbox" class="columns_checkbox<?php if(in_array('booking_id', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('children_count', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Number of Children', true); ?></a></li>
                            <li name="status"><a href="#" class="small" data-value="option2" value="status"  tabIndex="-1"><input type="checkbox" class="columns_checkbox<?php if(in_array('booking_id', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('status', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Status', true); ?></a></li>
                            <li name="room"><a href="#" class="small" data-value="option3" value="room"  tabIndex="-1"><input type="checkbox" class="columns_checkbox<?php if(in_array('booking_id', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('room', $settings)) { ?> checked class="selected_column" <?php } ?> />&nbsp;<?php echo l('Room', true); ?></a></li>
                            <li name="room_type"><a href="#" class="small" data-value="option5" value="room_type"  tabIndex="-1"><input type="checkbox" class="columns_checkbox<?php if(in_array('booking_id', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('room_type', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Room Type', true); ?></a></li>
                            <li name="check_in_date"><a href="#" class="small" data-value="option4" value="check_in_date"  tabIndex="-1"><input type="checkbox" class="columns_checkbox<?php if(in_array('booking_id', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('check_in_date', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Check-In Date', true); ?></a></li>
                            <li name="check_out_date"><a href="#" class="small" data-value="option5" value="check_out_date"  tabIndex="-1"><input type="checkbox" class="columns_checkbox<?php if(in_array('booking_id', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('check_out_date', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Check-Out Date', true); ?></a></li>
                            <li name="no_of_days"><a href="#" class="small" data-value="option6" value="no_of_days"  tabIndex="-1"><input type="checkbox" class="columns_checkbox<?php if(in_array('booking_id', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('no_of_days', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('No Of Days', true); ?></a></li>
                            <li name="unit_price"><a href="#" class="small" data-value="option6" value="unit_price"  tabIndex="-1"><input type="checkbox" class="columns_checkbox<?php if(in_array('booking_id', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('unit_price', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Unit Price', true); ?></a></li>
                            <li name="booking_source"><a href="#" class="small" data-value="option4" value="booking_source"  tabIndex="-1"><input type="checkbox" class="columns_checkbox<?php if(in_array('booking_id', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('booking_source', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Booking Source', true); ?></a></li>
                            <li name="customer_names"><a href="#" class="small" data-value="option6" value="customer_names"  tabIndex="-1"><input type="checkbox" class="columns_checkbox<?php if(in_array('booking_id', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('customer_names', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Customer Names', true); ?></a></li>
                            <li name="customer_email"><a href="#" class="small" data-value="option6" value="customer_email"  tabIndex="-1"><input type="checkbox" class="columns_checkbox<?php if(in_array('booking_id', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('customer_email', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Customer Email', true); ?></a></li>
                            <li name="customer_type"><a href="#" class="small" data-value="option6" value="customer_type"  tabIndex="-1"><input type="checkbox" class="columns_checkbox<?php if(in_array('booking_id', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('customer_type', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Customer Type', true); ?></a></li>
                            <li name="customer_notes"><a href="#" class="small" data-value="option6" value="customer_notes"  tabIndex="-1"><input type="checkbox" class="columns_checkbox<?php if(in_array('booking_id', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('customer_notes', $settings)) { ?> checked  <?php } ?> />&nbsp;<?php echo l('Customer Notes', true); ?></a></li>
                            <li name="payment"><a href="#" class="small" data-value="option6" value="payment"  tabIndex="-1"><input type="checkbox" class="columns_checkbox<?php if(in_array('payment', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('payment', $settings)) { ?> checked  <?php } ?> />&nbsp;<?php echo l('Payment', true); ?></a></li>
                            <li name="group_name"><a href="#" class="small" data-value="option1" value="group_name"  tabIndex="-1"><input type="checkbox" class="columns_checkbox<?php if(in_array('group_name', $settings)) { ?> selected_column <?php } ?>" <?php if(in_array('group_name', $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo l('Group Name', true); ?></a></li>
                            <?php
                           
                            if(isset($customer_fields) && count($customer_fields) !=0){
                                foreach($customer_fields as $fields){
                                    $field = preg_replace("/^'|[^A-Za-z0-9\'-]|'?/", '', $fields['name']);
                                    if($fields['show_on_in_house_report']==1){ ?>
                                        <li name="<?php echo $field; ?>">
                                            <a href="#" class="small" data-value="option1" value="<?php echo $field; ?>"  tabIndex="-1">
                                                <input type="checkbox" class="columns_checkbox<?php if(in_array($field, $settings)) { ?> selected_column <?php } ?>" <?php if(in_array($field, $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo $fields['name']; ?>
                                            </a>
                                        </li>
                                    <?php }
                                }
                            }

                             if(isset($booking_fields) && count($booking_fields) !=0){
                            foreach($booking_fields as $fields){ 
                                $field = preg_replace("/^'|[^A-Za-z0-9\'-]|'?/", '', $fields['name']);?>
                                <li name="<?php echo $field; ?>">
                                    <a href="#" class="small" data-value="option1" value="<?php echo $field; ?>"  tabIndex="-1">
                                        <input type="checkbox" class="columns_checkbox<?php if(in_array($field, $settings)) { ?> selected_column <?php } ?>" <?php if(in_array($field, $settings)) { ?> checked <?php } ?> />&nbsp;<?php echo $fields['name']; ?>
                                    </a>
                                </li>
                        <?php }
                        } ?>
                        </ul>
                    </div>
                    <button style="margin: 0 10px;" id="printReportButton" class="btn btn-primary pull-right hidden-print"><span class="glyphicon glyphicon-print" title="Print Report"></span></button>
                    <?php $start_date = ($this->uri->segment(4) != '') ? $this->uri->segment(4) : ""; ?>
                    <?php $end_date = ($this->uri->segment(5) != '') ? $this->uri->segment(5) : ""; ?>
                    <?php $book_type = ($this->uri->segment(6) != '') ? $this->uri->segment(6) : ""; ?>
                    <?php $param = $start_date."/".$end_date."/".$book_type;?>
                    <a  href="<?php if($param != '//'){ echo base_url()."reports/reservation/download_inhouse_csv_export/".$param; } else { echo base_url()."reports/reservation/download_inhouse_csv_export/"; } ?>" class="btn btn-primary pull-right ">
                        <span title="Export to CSV" class="glyphicon glyphicon-download-alt"></span>
                    </a>
                </div>
            </div><!-- /.form-inline -->
        </div>
    </div>
    <div>
        <!--            <div class="h3 col-lg-3"><?=$hotel_name;?></div>-->

        <div style="float: left; margin: 0 18px;">
            <b><?php echo "Total Bookings = ".count($bookings); ?></b>
        </div>

        <div class="h3 col-lg-9" style="font-size: 20px;">
                <span class="visible-print">
                    <b><?php echo l('reporting_period'); ?> </b>: <?=date('M d, Y', strtotime($from_date));?> – <?=date('M d, Y', strtotime($to_date));?><br>
                </span>
            <span class="visible-print"><b><?php echo l('report_date'); ?></b> : <?=date('M d, Y', strtotime(date('Y-m-d')));?></span>
        </div>



    </div>
    <div class="col-lg-12 table-responsive">
    <table class="table table-hover table-condensed inhouse_table hidden">
        <thead>
        <tr>
            <th name="booking_id" class="text-left booking_id"><?php echo l('booking')." ".l('id'); ?></a></th>
            <th name="adult_count" class="text-left adult_count"><?php echo l('Number of Adults'); ?></a></th>
            <th name="children_count" class="text-left children_count"><?php echo l('Number of Children'); ?></a></th>
            <th name="status" class="text-center status"><?php echo l('status'); ?></a></th>
            <th name="room" class="text-left room"><?php echo l('room'); ?></th>
            <th name="room_type" class="text-left room_type"><?php echo l('Room Type', true); ?></th>
            <th name="check_in_date" class="text-left check_in_date"><?php echo l('check_in_date'); ?></th>
            <th name="check_out_date" class="text-left check_out_date"><?php echo l('check_out_date'); ?></th>
            <th name="no_of_days" class="text-left no_of_days"><?php echo l('No of Days', true); ?></th>
            <th name="unit_price" class="text-left unit_price"><?php echo l('Unit Price (price by Night)', true); ?></th>
            <th name="booking_source" class="text-left booking_source"><?php echo l('Booking source', true); ?></th>
            <th name="customer_names" class="text-left customer_names"><?php echo l('customer_name'); ?></th>
            <th name="customer_email" class="text-left customer_email"><?php echo l('customer_email'); ?></th>
            <th name="customer_type" class="text-left customer_type"><?php echo l('customer_type'); ?></th>
            <th name="customer_notes" class="text-left customer_notes"><?php echo l('customer_notes'); ?></th>
            <th name="payment" class="text-left payment"><?php echo l('Payment'); ?></th>
            <th name="group_name" class="text-left group_name"><?php echo l('Group Name'); ?></a></th>

            <?php krsort($common_customer_fields);
            if(count($common_customer_fields) !=0){
                foreach($common_customer_fields as $fields){
                    if(isset($fields['show_on_in_house_report']) && $fields['show_on_in_house_report'] == 1){
                        echo ($fields['name'] != 'Name' && $fields['name'] != 'Customer Type' && $fields['name'] != 'Notes') ? "<th class=\"text-left\">".$fields['name']."</th>" : '';
                    }
                }
            }

            if(isset($customer_fields) && count($customer_fields) !=0){
                foreach($customer_fields as $fields){
                    if($fields['show_on_in_house_report']==1){
                        echo "<th class=\"text-left ".preg_replace("/^'|[^A-Za-z0-9\'-]|'?/", '', $fields['name'])."\">".$fields['name']."</th>";
                    }
                }
            }
            if(isset($booking_fields) && count($booking_fields) !=0){
                foreach($booking_fields as $fields){
                    // if($fields['show_on_in_house_report']==1){

                        echo "<th class=\"text-left ".preg_replace("/^'|[^A-Za-z0-9\'-]|'?/", '', $fields['name'])."\">".$fields['name']."</th>";
                    // }
                }
        }
            ?>
        </tr>
        </thead>
        <tbody>
        <?php
        $this->ci->load->library('rate');
        $common_booking_sources = json_decode(COMMON_BOOKING_SOURCES, true);

        foreach ($bookings as $booking):

            if ($booking['state'] == OUT_OF_ORDER)
                continue;

            $amount = $booking['rate'];
            if ($booking['use_rate_plan'] && $booking['rate_plan_id'] != '0')
            {
                $rate_array = $this->ci->rate->get_rate_array(
                    $booking['rate_plan_id'],
                    $booking['check_in_date'],
                    $booking['check_out_date'],
                    $booking['adult_count'],
                    $booking['children_count']
                );
                if (isset($rate_array[0]))
                    $amount = $rate_array[0]['rate'];
            }

            $daily_rate = round(($amount), 2, PHP_ROUND_HALF_UP);
            if($booking['pay_period'] == WEEKLY){
                $daily_rate = round(($amount / 7), 2, PHP_ROUND_HALF_UP);
            }
            elseif($booking['pay_period'] == MONTHLY){
                $daily_rate = round(($amount / 30), 2, PHP_ROUND_HALF_UP);
            }


            ?>
            <tr>
                <td class="booking_id">
                    <?php
                    echo $booking['booking_id'];
                    ?>
                </td>
                <td class="adult_count">
                    <?php
                    echo $booking['adult_count'];
                    ?>
                </td>
                <td class="children_count">
                    <?php
                    echo $booking['children_count'];
                    ?>
                </td>
                <td class="text-center status">
                    <?php
                    echo (isset($states[$booking['state']]) && $states[$booking['state']]) ? $states[$booking['state']] : '';
                    ?>
                </td>
                <td class="room">
                    <?php
                    echo $booking['room_name'] ? $booking['room_name'] : 'Not Assigned';
                    ?>
                </td>
                <td class="room_type">
                    <?php
                    echo $booking['r_name'];
                    ?>
                </td>
                <td class="check_in_date">
                    <?php
                    echo ($this->enable_hourly_booking == 1 ? date('Y-m-d h:i A', strtotime($booking['check_in_date'])) : ($booking['check_in_date'] ? date('Y-m-d', strtotime($booking['check_in_date'])) : ''));
                    ?>
                </td>
                <td class="check_out_date">
                    <?php
                    echo ($this->enable_hourly_booking == 1 ? date('Y-m-d h:i A', strtotime($booking['check_out_date'])) : ($booking['check_out_date'] ? date('Y-m-d', strtotime($booking['check_out_date'])) : ''));
                    ?>
                </td>
                <td class="no_of_days">
                    <?php
                    echo $booking['no_of_days'];
                    ?>
                </td>
                <td class="unit_price">
                    <?php
                    echo $daily_rate;
                    ?>
                </td>
                <td class="booking_source">
                    <?php
                    echo is_numeric($booking['source']) ? (isset($common_booking_sources[$booking['source']]) ? l($common_booking_sources[$booking['source']],true) : "") :l($booking['source'],true);
                    ?>
                </td>
                <td class="customer_names">
                    <?php
                    echo get_customer_names($booking['customer_name'], $booking['staying_customers'], $booking['guest_count']);
                    ?>
                </td>
                <td class="customer_email">
                    <?php
                    echo $booking['email'];
                    ?>
                </td>
                <td class="customer_type">
                    <?php
                    echo $booking['customer_type_name'];
                    ?>
                </td>

                <td class="customer_notes">
                    <?php
                    echo $booking['booking_notes'];
                    ?>
                </td>
                <td class="payment">
                    <?php
                    echo $booking['payment_total'];
                    ?>
                </td>
                <td class="group_name">
                    <?php
                    echo $booking['group_name'];
                    ?>
                </td>
                <?php
                if(count($common_customer_fields) !=0) {
                    foreach ($common_customer_fields as $id => $field) {
                        if(isset($field['show_on_in_house_report']) && $field['show_on_in_house_report'] == 1 && ($field['name'] != 'Notes' || $field['name'] != 'Name' || $field['name'] != 'Customer Type')){
                            echo ($field['name'] != 'Name' && $field['name'] != 'Customer Type' && $field['name'] != 'Notes') ? ("<td class=''>" . (isset($booking['customer_common_fields'][$id]) ? $booking['customer_common_fields'][$id] : "") . "</td>") : '';
                        }
                    }
                }

                if(isset($customer_fields) && count($customer_fields) !=0) {
                    foreach ($customer_fields as $field) {
                        if ($field['show_on_in_house_report'] == 1) {
                            echo "<td class='".preg_replace("/^'|[^A-Za-z0-9\'-]|'?/", '', $field['name'])."'>" . (isset($booking['customer_fields'][$field['id']]) ? $booking['customer_fields'][$field['id']] : "") . "</td>";
                        }
                    }
                }

                if(isset($booking_fields) && count($booking_fields) !=0) {
                    foreach ($booking_fields as $field) {
                        echo "<td class='".preg_replace("/^'|[^A-Za-z0-9\'-]|'?/", '', $field['name'])."'>" . (isset($booking['booking_custom_fields'][$field['id']]) ? $booking['booking_custom_fields'][$field['id']] : "") . "</td>";
                    }
                }
                ?>
            </tr>
        <?php
        endforeach;
        ?>
        </tbody>

    </table>
    </div>

</div>
    </div>
    </div>
